#!/bin/bash

SCRIPT_DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"
cd "$SCRIPT_DIR"

echo "================================================"
echo "  SMUL Personal - Inicio de Docker Compose"
echo "================================================"
echo ""

if ! command -v docker &> /dev/null
then
    echo "ERROR: Docker no está instalado o no está ejecutándose!"
    echo "Por favor instala Docker y asegúrate de que esté ejecutándose."
    echo ""
    read -p "Presiona Enter para salir..."
    exit 1
fi

if [ ! -f "docker-compose-run.yml" ]; then
    echo "ERROR: docker-compose-run.yml no encontrado!"
    echo "Por favor asegúrate de ejecutar este script desde el directorio correcto."
    echo ""
    read -p "Presiona Enter para salir..."
    exit 1
fi

echo "Iniciando Docker Compose..."
echo ""
echo "NOTA: Presiona Ctrl+C para detener todos los contenedores"
echo "================================================"
echo ""

cleanup() {
    echo ""
    echo "================================================"
    echo "Deteniendo contenedores..."
    echo "================================================"
    docker compose -f docker-compose-run.yml down
    echo ""
    echo "Todos los contenedores han sido detenidos."
    exit 0
}

trap cleanup SIGINT SIGTERM

docker compose -f docker-compose-run.yml up

cleanup
